<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:decimal-format name="getal" decimal-separator="," grouping-separator="."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Rapport Berekening Vtlb</title>
				<style>
					h1 {font-style: normal; font-weight: bold; font-size:12pt; font-family:Verdana; color:Darkblue}
					h2 {font-style: normal; font-weight: bold; font-size:8pt; font-family:Verdana; color:Darkblue; display:inline}
					h3 {font-style: normal; font-weight: bold; font-size:9pt; font-family:Verdana; color:Black; display:inline}
					h4 {font-style: normal; font-weight: normal; font-size:8pt; font-family:Verdana; color:Black; display:inline}
					h5 {font-style: normal; font-weight: normal; font-size:8pt; font-family:Verdana; color:Black}
					h6 {font-style: normal; font-weight: normal; font-size:7pt; font-family:Verdana; color:Black; display:inline}
					h7 {font-style: normal; font-weight: bold; font-size:8pt; font-family:Verdana; color:Black; display:inline}
					h2.red {font-style: normal; font-weight: bold; font-size:8pt; font-family:Verdana; color:Red; display:inline}
					h4.grayitalic {font-style: italic; font-weight: normal; font-size:8pt; font-family:Verdana; color:Gray; display:inline}
					h2.grayitalic {font-style: italic; font-weight: bold; font-size:8pt; font-family:Verdana; color:Gray; display:inline}
				</style>
			</head>
			<body>
				<style>
					@media print {DIV.PAGEBREAK {page-break-before: always; page-break-inside: auto; orphans:1; widows:1}}
				</style>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="100%">
								<h1 align="center">Rapport Berekening Vtlb</h1>
							</td>
						</tr>
						<tr>
							<td width="100%">
								<h5 align="center">Versie <xsl:value-of select="VTLBCalculator/Berekening_Gegevens/Plug-in/Versienummer"/>.<xsl:value-of select="VTLBCalculator/Berekening_Gegevens/Plug-in/Releasenummer"/>
								</h5>
							</td>
						</tr>
						<tr>
							<td width="100%">
								&#160;
							</td>
						</tr>
					</tbody>
				</table>
				<p>
					<br clear="left"/>
				</p>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="50%">
								<h4>Berekeningsversie </h4>
							</td>
							<td colspan="2" width="25%">
								<h4>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Gebruikte_BerekeningsVersie"/>
									</xsl:call-template>
								</h4>
							</td>
						</tr>
						<tr>
							<td width="50%">
								<h4>Berekening uitgevoerd op </h4>
							</td>
							<td colspan="2" width="25%">
								<h4>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Uitgevoerd_Op_Datum"/>
									</xsl:call-template>
								</h4>
							</td>
						</tr>
						<tr>
							<td width="50%">&#160;</td>
							<td width="25%"/>
							<td width="25%"/>
						</tr>
						<tr>
							<td width="50%">
								<h4>Naam schuldenaar</h4>
							</td>
							<td colspan="2" width="25%">
								<h2>
									<xsl:value-of select="VTLBCalculator/Schuldenaar_Gegevens/Naam"/>
								</h2>
							</td>
						</tr>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<tr>
								<td width="50%">
									<h4>Naam partner</h4>
								</td>
								<td colspan="2" width="25%">
									<h2>
										<xsl:value-of select="VTLBCalculator/Partner_Gegevens/Naam"/>
									</h2>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td width="50%">
								<h4>Insolventienummer schuldenaar</h4>
							</td>
							<td colspan="2" width="25%">
								<h2>
									<xsl:value-of select="VTLBCalculator/Schuldenaar_Gegevens/Insolventienummer"/>
								</h2>
							</td>
						</tr>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<tr>
								<td width="50%">
									<h4>Insolventienummer partner</h4>
								</td>
								<td colspan="2" width="25%">
									<h2>
										<xsl:value-of select="VTLBCalculator/Partner_Gegevens/Insolventienummer"/>
									</h2>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td width="50%">
								<h4>Datum toelating Wsnp </h4>
							</td>
							<td width="25%">
								<h4>schuldenaar: </h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Schuldenaar_Gegevens/Datum_Toepassing_WSNP"/>
									</xsl:call-template>
								</h2>
							</td>
							<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
								<td width="25%">
									<h4>partner: </h4>
									<h2>
										<xsl:call-template name="maakDatum">
											<xsl:with-param name="datum" select="VTLBCalculator/Partner_Gegevens/Datum_Toepassing_WSNP"/>
										</xsl:call-template>
									</h2>
								</td>
							</xsl:if>
						</tr>
						<!--m*4.7 nieuw StartdatumLptWsnp -->
						<tr>
							<td width="50%">
								<h4>Startdatum looptijd Wsnp </h4>
							</td>
							<td width="25%">
								<h4>schuldenaar: </h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Schuldenaar_Gegevens/Startdatum_Looptijd_WSNP"/>
									</xsl:call-template>
								</h2>
							</td>
							<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
								<td width="25%">
									<h4>partner: </h4>
									<h2>
										<xsl:call-template name="maakDatum">
											<xsl:with-param name="datum" select="VTLBCalculator/Partner_Gegevens/Startdatum_Looptijd_WSNP"/>
										</xsl:call-template>
									</h2>
								</td>
							</xsl:if>
						</tr>
						<tr>
							<td width="50%">
								<h4>Datum berekening </h4>
							</td>
							<td colspan="2" width="25%">
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Gebruikte_BerekeningsDatum"/>
									</xsl:call-template>
								</h2>
							</td>
						</tr>
						<tr>
							<td width="50%">
								<h4>Berekening geldig </h4>
							</td>
							<td width="25%">
								<h4>van&#160;</h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Berekening_Geldig_Van"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="25%">
								<h4>tot en met&#160;</h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Berekening_Geldig_Tm"/>
									</xsl:call-template>
								</h2>
							</td>
						</tr>
						<tr>
							<td width="50%">&#160;</td>
							<td width="25%"/>
							<td width="25%"/>
						</tr>
					</tbody>
				</table>
				<p>
					<br clear="left"/>
				</p>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="25%">
								<h3>Algemene gegevens</h3>
							</td>
							<td width="25%"/>
							<td width="25%"/>
							<td width="25%"/>
						</tr>
						<tr>
							<td width="25%">
								<h4>Woonsituatie</h4>
							</td>
							<td width="25%"/>
							<td colspan="2" width="25%">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h2>
										<xsl:text>Met partner - </xsl:text>
									</h2>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
										<h2>
											<xsl:text>in (beperkte) gemeenschap van goederen</xsl:text>
										</h2>
									</xsl:if>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>
											<xsl:text>geen (beperkte) gemeenschap van goederen</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
									<h2>
										<xsl:text>Geen partner </xsl:text>
									</h2>
								</xsl:if>
							</td>
						</tr>
						<!-- m*4.6 huwelijk gesloten in -->
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
								<xsl:if test="not(VTLBCalculator/VTLB_Algemeen/Jaartal_huwelijk='')">
									<tr>
										<td width="25%">
										</td>
										<td width="25%"/>
										<td colspan="2" width="25%">
											<h2>
												Huwelijk gesloten in <xsl:value-of select="VTLBCalculator/VTLB_Algemeen/Jaartal_huwelijk"/>
											</h2>
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<tr>
							<td width="25%"/>
							<td width="25%"/>
							<td colspan="2" width="25%">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Samen_In_Regeling='Ja'">
										<h2>
											<xsl:text>beiden in regeling</xsl:text>
										</h2>
									</xsl:if>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Samen_In_Regeling='Nee'">
										<h2>
											<xsl:text>niet beiden in regeling</xsl:text>
										</h2>
									</xsl:if>
									<!-- 2.8.1 niet meer van toepassing alleen bij allenstaande ouder
							<xsl:if test="VTLBCalculator/Gezinssituatie/Toeslagpartners='Ja'">
							<h2><xsl:text>&#160;-&#160;toeslagpartners</xsl:text></h2>
							</xsl:if>
							<xsl:if test="VTLBCalculator/Gezinssituatie/Toeslagpartners='Nee'">
							<h2><xsl:text>&#160;-&#160;geen toeslagpartners</xsl:text></h2>
							</xsl:if>
							-->
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td width="25%"/>
							<td width="25%"/>
							<td colspan="2" width="25%">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aanwezig='Ja'">
										<h2>
											<xsl:text>met kinderen</xsl:text>
										</h2>
									</xsl:if>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aanwezig='Nee'">
										<h2>
											<xsl:text>zonder kinderen</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aanwezig='Ja'">
										<h2>
											<xsl:text>met kinderen&#160;-&#160;</xsl:text>
										</h2>
										<xsl:if test="VTLBCalculator/Gezinssituatie/Toeslagpartners='Ja'">
											<h2>
												<xsl:text>met toeslagpartner</xsl:text>
											</h2>
										</xsl:if>
										<xsl:if test="VTLBCalculator/Gezinssituatie/Toeslagpartners='Nee'">
											<h2>
												<xsl:text>zonder toeslagpartner</xsl:text>
											</h2>
										</xsl:if>
									</xsl:if>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aanwezig='Nee'">
										<h2>
											<xsl:text>zonder kinderen</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td width="25%">
								<h4>Geboortedata</h4>
							</td>
							<td width="25%"/>
							<td width="25%">
								<h4>schuldenaar: </h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Schuldenaar_Gegevens/Geboortedatum"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="25%">
								<!-- m*3.3.1 <xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'"> -->
								<xsl:if test="not(VTLBCalculator/Partner_Gegevens/Geboortedatum='')">
									<h4>partner: </h4>
									<h2>
										<xsl:call-template name="maakDatum">
											<xsl:with-param name="datum" select="VTLBCalculator/Partner_Gegevens/Geboortedatum"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td width="25%">
								<h4>Leeftijd(en)</h4>
							</td>
							<td width="25%"/>
							<td width="25%">
								<h4>schuldenaar: </h4>
								<h2>
									<xsl:value-of select="VTLBCalculator/VTLB_Algemeen/Leeftijd_Schuldenaar"/>
								</h2>
							</td>
							<td width="25%">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>partner: </h4>
									<h2>
										<xsl:value-of select="VTLBCalculator/VTLB_Algemeen/Leeftijd_Partner"/>
									</h2>
								</xsl:if>
							</td>
						</tr>
					</tbody>
				</table>
				<p>
					<br clear="left"/>
				</p>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="25%">
								<h4>Kinderen:</h4>
							</td>
							<td width="25%"/>
							<td width="25%"/>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Aantal (inwonende) kinderen</h4>
							</td>
							<td width="25%">
								<h2 align="center">
									<xsl:value-of select="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Onder+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Boven+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Overigen"/>
								</h2>
							</td>
							<td width="25%">
								<h4>Leeftijden: </h4>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Onder+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Boven+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Overigen &gt;0">
									<h2>
										<xsl:for-each select="VTLBCalculator/Gezinssituatie/Kinderen_Geboren">
											&#160;<xsl:value-of select="Kind_Leeftijd"/>
											<xsl:if test="position() != last()">
												<xsl:text>,</xsl:text>
											</xsl:if>
										</xsl:for-each>
									</h2>
								</xsl:if>
							</td>
						</tr>
						<!-- m*3.3.1
				<tr>
					<td colspan="4" width="25%">
						<h4>geboortedata:</h4>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Onder+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Boven+
						VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Overigen &gt;0">
						<h2>&#160;
							<xsl:for-each select="VTLBCalculator/Gezinssituatie/Kinderen_Geboren">
							&#160;<xsl:call-template name="maakDatum"><xsl:with-param name="datum" select="Kind_Datum"/>
							</xsl:call-template>&#160;(<xsl:value-of select="Kind_Leeftijd"/>)
							</xsl:for-each>
						</h2>
						</xsl:if>
					</td>
				</tr>
				-->
						<tr>
							<td colspan="2" width="25%">
								<h4>- waarvan ouder dan 17, VO - onderbouw</h4>
							</td>
							<td width="25%">
								<h2 align="center">
									<xsl:value-of select="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Onder"/>
								</h2>
							</td>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>- waarvan ouder dan 17, VO - bovenbouw</h4>
							</td>
							<td width="25%">
								<h2 align="center">
									<xsl:value-of select="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Ouder17_VO_Boven"/>
								</h2>
							</td>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>- waarvan overigen</h4>
							</td>
							<td width="25%">
								<h2 align="center">
									<xsl:value-of select="VTLBCalculator/Gezinssituatie/Kinderen_Aantal/Aantal_Overigen"/>
								</h2>
							</td>
							<td width="25%"/>
						</tr>
						<tr>
							<td width="25%"/>
							<td width="25%"/>
							<td width="25%"/>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Relevante partnerinformatie verstrekt?</h4>
							</td>
							<td width="25%">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/VTLB_Algemeen/Inkomen_Partner_Bekend='Ja'">
										<h2>
											<xsl:text>Ja</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/VTLB_Algemeen/Inkomen_Partner_Bekend='Nee'">
										<h2>
											<xsl:text>Nee</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Schuldenaar of schuldenaren in een inrichting?</h4>
							</td>
							<td width="25%">
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<h2>
										<xsl:text>Ja - schuldenaar </xsl:text>
									</h2>
									<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
										<h2>
											<xsl:text>en partner</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
										<h2>
											<xsl:text>Ja - partner</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Nee'">
											<h2>
												<xsl:text>Nee</xsl:text>
											</h2>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
										<h2>
											<xsl:text>Nee</xsl:text>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="25%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<tr>
							<td colspan="4" width="25%">
								<p>
									<h3>Verhoging van de beslagvrije voet in verband met woonlasten - zie blad 3</h3>
								</p>
							</td>
						</tr>
						<!-- m*4.5 als je een eigen woning hebt zou je alleen de tekst Permanente correctie zien. Dus weggehaald bij eigen woning -->
						<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)=0">
							<tr>
								<td colspan="2" width="25%">
									<h4>
										<strong>Permanente correctie</strong>
									</h4>
								</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="10%"/>
							</tr>
							<tr>
								<td colspan="2" width="25%">
									<h4>Recht op huurtoeslag gezien de aard van de woning </h4>
										<xsl:choose>
											<xsl:when test="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Recht_huurtoeslag_Aard_woning='Ja'">
												<h4>&#x25CF; <strong>Ja</strong>    &#x25CB; Nee</h4>
											</xsl:when>
											<xsl:when test="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Recht_huurtoeslag_Aard_woning='Nee'">
												<h4>&#x25CB; Ja    &#x25CF; <strong>Nee</strong></h4>
											</xsl:when>
											<xsl:otherwise>
												<h4>&#x25CB; Ja    &#x25CF; <strong>Nee</strong></h4>
											</xsl:otherwise>
										</xsl:choose>
								</td>
								<td width="20%" align="right"/>
								<td width="20%" align="right"/>
								<td width="10%"/>
							</tr>
						</xsl:if>
						
						
						<!--m*4.5.1 Toevoegingen tijdelijke correctie -->
						<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Startdatum)&gt;8">
							<tr>
								<td colspan="2" width="25%">
									<p>
										<!-- hieronder kun je kijken wat er nu werkelijk instaat.
										-=<xsl:value-of select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Startdatum"/>=-
										len(<xsl:value-of select="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Startdatum)"/>)
										-->
										<br clear="left"/>
									</p>
								</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="10%"/>
							</tr>
							<tr>
								<td colspan="2" width="25%">
									<h4>
										<strong>Tijdelijke correctie</strong>
									</h4>
								</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="10%"/>
							</tr>
							<tr>
								<td colspan="2" width="25%">
									<h4>
										Startdatum tijdelijke correctie <strong>
											<xsl:call-template name="maakDatum">
												<xsl:with-param name="datum" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Startdatum"/>
											</xsl:call-template>
											</strong>
									</h4>
								</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="10%"/>
							</tr>
							<!--m*4.5.1 Toevoegingen einddatum -->
							<tr>
								<td colspan="2" width="25%">
									<h4>
										Einddatum tijdelijke correctie <strong>
											<xsl:call-template name="maakDatum">
												<xsl:with-param name="datum" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Eindedatum"/>
											</xsl:call-template>
											</strong>
									</h4>
								</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="10%"/>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Correctie toegepast </h4>
								<xsl:choose>
									<xsl:when test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar)&gt;0">
										<h4>&#x25CF; <strong>Ja</strong>    &#x25CB; Nee</h4>
									</xsl:when>
									<xsl:when test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
										<h4>&#x25CF; <strong>Ja</strong>    &#x25CB; Nee</h4>
									</xsl:when>
									<xsl:otherwise>
										<h4>&#x25CB; Ja    &#x25CF; <strong>Nee</strong></h4>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td width="20%" align="right"/>
							<td width="20%" align="right"/>
							<td width="10%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar)&gt;0">
							<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar!=' '">
								<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar!='&#x0A;'">
									<tr>
										<td colspan="2" width="25%">
											<h4>
												<strong>Woonkosten: huurwoning</strong>
											</h4>
										</td>
										<td width="20%"/>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Kale huur per maand</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Servicekosten per maand</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Servicekosten2/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%"/>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur2/Schuldenaar!='&#x0A;'">
														<h4>
															<strong>__________</strong>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>
												Huur: kale huur + max. <xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/MaxServicekosten2/Schuldenaar"/>
												</xsl:call-template>&#160;servicekosten
											</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Huur/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<p>
												<br clear="left"/>
											</p>
										</td>
										<td width="20%"/>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in beslagvrije voet tijdelijk</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in beslagvrije voet permanent</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV_Permanent"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in nominaal bedrag</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_boven_max_huurgrens"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Maximale huurgrens/kale huur</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Max_huurgrens_kale_huur"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<!--m*4.5.1 Toevoegingen Drempelbedrag -->
									<tr>
										<td colspan="2" width="25%">
											<h4>Drempelbedrag voor tijdelijke correctie woonlasten</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Drempelbedrag"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
							<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
								<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
									<tr>
										<td colspan="2" width="25%">
											<h4>
												<strong>Woonkosten: eigen woning</strong>
											</h4>
										</td>
										<td width="20%"/>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Hypotheekrente en erfpacht per maand</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Overige kosten eigen woning (</h4>
											<h2>
												<xsl:call-template name="maakBedrag2">
													<xsl:with-param name="bedrag2" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZPercentage"/>
												</xsl:call-template>
											</h2>
											<h4>&#160;% van </h4>
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZWaarde"/>
												</xsl:call-template>
											</h2>
											<h4>)</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td width="25%"/>
										<td width="25%"/>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
														<h4>
															<strong>__________</strong>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Kosten eigen woning</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Kosten_Eigen_Woning/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<p>
												<br clear="left"/>
											</p>
										</td>
										<td width="20%"/>
										<td width="20%"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in beslagvrije voet tijdelijk</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in beslagvrije voet permanent</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV_Permanent"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Correctie in nominaal bedrag</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_boven_max_huurgrens"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<tr>
										<td colspan="2" width="25%">
											<h4>Maximale huurgrens/kale huur</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Max_huurgrens_kale_huur"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
									<!--m*4.5.1 Toevoegingen Drempelbedrag -->
									<tr>
										<td colspan="2" width="25%">
											<h4>Drempelbedrag voor tijdelijke correctie woonlasten</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_Drempelbedrag"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%" align="right"/>
										<td width="10%"/>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<tr>
							<td colspan="2" width="25%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="10%"/>
						</tr>
						<!-- Met partner -->
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<xsl:if test="VTLBCalculator/VTLB_Inkomsten/NettoNadeelBijtellingAutoBedrag/Schuldenaar != '0,00' or VTLBCalculator/VTLB_Inkomsten/NettoNadeelBijtellingAutoBedrag/Partner != '0,00'">
								<tr>
									<td colspan="4" width="25%">
										<h4>
											<h3>Privegebruik auto van de zaak: <strong>Ja</strong> - zie blad 2 </h3><h4>(netto nadeel fiscale bijtelling auto van de zaak)</h4>
										</h4>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
						<!-- GEEN partner -->
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
							<tr>
								<td colspan="4" width="25%">
									<h4>
										<h3>Verlaging van de beslagvrije voet in verband met auto van de zaak - zie blad 3</h3>
									</h4>
								</td>
							</tr>
							<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Lease_Auto/Schuldenaar)&gt;0">
								<tr>
									<td colspan="2" width="25%">
										<h4>
											Privegebruik auto van de zaak &#x25CF; <strong>Ja</strong>    &#x25CB; Nee
										</h4>
									</td>
									<td width="20%" align="right"/>
									<td width="20%" align="right"/>
									<td width="10%"/>
								</tr>
								<tr>
									<td colspan="2" width="25%">
										<h4>Netto nadeel van fiscale bijtelling auto van de zaak</h4>
									</td>
									<td width="20%" align="right">
										<h4>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Lease_Auto/Schuldenaar"/>
											</xsl:call-template>
										</h4>
									</td>
									<td width="20%" align="right">
										<h4>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Lease_Auto/Partner"/>
											</xsl:call-template>
										</h4>
									</td>
									<td width="10%"/>
								</tr>
							</xsl:if>
							<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Lease_Auto/Schuldenaar)=0">
								<tr>
									<td colspan="2" width="25%">
										<h4>
											Netto nadeel van fiscale bijtelling auto van de zaak &#x25CB; Ja    &#x25CF; <strong>Nee</strong>
										</h4>
									</td>
									<td width="20%" align="right"/>
									<td width="20%" align="right"/>
									<td width="10%"/>
								</tr>
							</xsl:if>
						</xsl:if>
					</tbody>
				</table>
				<p>
					<br clear="left"/>
				</p>
				<div style="page-break-before: always"/>
				<!-- <div class="pagebreak"><P clear="left"/></div> -->
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="25%">&#160;</td>
							<td width="25%"/>
							<td width="12%"/>
							<td width="12%"/>
							<td width="12%"/>
							<td width="12%"/>
							<td width="02%"/>
						</tr>
						<!--Kopje-->
						<tr>
							<td colspan="2" width="25%">
								<h3>Inkomsten met afzonderlijke uitkering vakantiegeld</h3>
							</td>
							<td colspan="2" width="12%" align="right">
								<h4>
									<strong>Schuldenaar</strong>
								</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>Partner</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h3/>
							</td>
							<td width="12%" align="right">
								<h4>Fiscaal</h4>
							</td>
							<td width="12%" align="right">
								<h4>Netto</h4>
							</td>
							<td width="12%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>Fiscaal</h4>
								</xsl:if>
							</td>
							<td width="12%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>Netto</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Loon uit dienstbetrekking</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering WW</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WW/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WW/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WW/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WW/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering AOW</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_AOW/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_AOW/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_AOW/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_AOW/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering ANW</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ANW/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ANW/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ANW/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ANW/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering Participatiewet</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WWB/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WWB/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WWB/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WWB/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering WAO/WIA</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WAO/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WAO/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WAO/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_WAO/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overige uitkeringen</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_Overig/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_Overig/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_Overig/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_Overig/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overige inkomens</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens_MetVT/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens_MetVT/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens_MetVT/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens_MetVT/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Bruto vakantiegeld</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_AfzVT_Bruto_Vakantiegeld/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_AfzVT_Bruto_Vakantiegeld/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Bruto extra salaris</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_AfzVT_Bruto_Extra_Salaris/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_AfzVT_Bruto_Extra_Salaris/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4><xsl:value-of select="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld_omschrijving/Schuldenaar"/></h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
						</tr>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<tr>
								<td colspan="2" width="25%">
									<h4><xsl:value-of select="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld_omschrijving/Partner"/></h4>
								</td>
								<td colspan="2" width="12%" align="right"></td>
								<td colspan="2" width="12%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="02%"/>
							</tr>
						</xsl:if>
						<!--Kopje-->
						<tr>
							<td colspan="2" width="25%">
								<h3>Inkomsten met inbegrepen vakantiegeld</h3>
							</td>
							<td colspan="2" width="12%" align="right"/>
							<td colspan="2" width="12%" align="right"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Loon uit dienstbetrekking inclusief vakantiegeld</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid_ZonderAfzVG/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid_ZonderAfzVG/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid_ZonderAfzVG/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Loon_Arbeid_ZonderAfzVG/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Uitkering ZW</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ZW/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ZW/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ZW/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Uitkering_ZW/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Pensioen</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Pensioen/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Pensioen/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Pensioen/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Pensioen/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overige inkomens inclusief vakantiegeld</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_Netto_ZonderAfzVG/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_Netto_ZonderAfzVG/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_Netto_ZonderAfzVG/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_Netto_ZonderAfzVG/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!-- e*4.2.1
						<tr>
							<td colspan="2" width="25%">
								<h4>Bruto vakantiegeld</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_ZonderAfzVT_Bruto_Vakantiegeld/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_ZonderAfzVT_Bruto_Vakantiegeld/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						-->
						<!-- e*4.3.1 commentaar gemaakt -->
						<!-- e*4.4.1 weer terug -->
						<tr>
							<td colspan="2" width="25%">
								<h4>Bruto extra salaris</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_ZonderAfzVT_Bruto_Extra_Salaris/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomens_ZonderAfzVT_Bruto_Extra_Salaris/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--Kopje-->
						<tr>
							<td colspan="2" width="25%">
								<h3>Inkomsten zonder vakantiegeld</h3>
							</td>
							<td colspan="2" width="12%" align="right"/>
							<td colspan="2" width="12%" align="right"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overige inkomsten uit arbeid</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overige_Inkomsten_Arbeid/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overige_Inkomsten_Arbeid/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overige_Inkomsten_Arbeid/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overige_Inkomsten_Arbeid/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Partneralimentatie</h4>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Alimentatie/SchuldenaarBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Alimentatie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Alimentatie/PartnerBruto"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Alimentatie/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--Kopje-->
						<tr>
							<td colspan="2" width="25%">
								<h3>Netto-inkomsten</h3>
							</td>
							<td colspan="2" width="12%" align="right"/>
							<td colspan="2" width="12%" align="right"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Heffingskortingen</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Heffingskortingen/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Heffingskortingen/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Belastingteruggaven</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Belastingteruggaven/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Belastingteruggaven/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overige inkomens</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Andere_Netto_Inkomens/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Kinderalimentatie</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Kinderalimentatie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Kinderalimentatie/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Geschatte eindejaarsuitkering</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--Kopje-->
						<tr>
							<td colspan="2" width="25%">
								<h3>Inkomsten niet voor beslagvrije voet</h3>
							</td>
							<td colspan="2" width="12%" align="right"/>
							<td colspan="2" width="12%" align="right"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Tegemoetkoming auto/reiskosten werkgever</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Tegemoetkoming_Autokosten_Werkgever/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Tegemoetkoming_Autokosten_Werkgever/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Commerci&#235;le onderverhuur</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Inkomsten_Verhuur/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Inkomsten_Verhuur/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Tegemoetkoming inwonenden</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Inkomsten_Inwoning/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Inkomsten_Inwoning/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Thuiswerk vergoeding</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Thuiswerk_Vergoeding/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Thuiswerk_Vergoeding/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>Representatiekostenvergoeding</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Representatiekostenvergoeding/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Representatiekostenvergoeding/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<!--m*4.6 -->
								<h4>Vergoeding int. chauffeurs</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Vergoeding_Vrachtwagenchauffeurs/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Vergoeding_Vrachtwagenchauffeurs/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--m*5.0 -->
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<tr>
								<td colspan="2" width="25%">
									<h4>Netto nadeel van fiscale bijtelling auto van de zaak</h4>
								</td>
								<td colspan="2" width="12%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/NettoNadeelBijtellingAutoBedrag/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</td>
								<td colspan="2" width="12%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/NettoNadeelBijtellingAutoBedrag/Partner"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="02%"/>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="2" width="25%">
								<h4>Overig</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_niet_voor_BVV/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td colspan="2" width="12%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Overig_niet_voor_BVV/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%"/>
							<td colspan="2" width="12%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>

						<!-- m*4.6 in/ex vakantiegeld en eindejaarsuitkering -->
						<xsl:choose>
							<xsl:when test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
								<!-- Als er geen gemeenschap is dan kan het zijn dat er een regel bij moet -->
								<!-- Als gemeenschap van goederen niet op Nee staat, is er of wel gemeenschap van goederen of geen partner  -->
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Schuldenaar != '0,00'">
									<tr>
										<td colspan="2" width="25%"><h4>Totaal inkomen inclusief vakantiegeld en eindejaarsuitkering</h4></td>
										<td colspan="2" width="12%" align="right">
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar"/>
												</xsl:call-template>
											</h2>
										</td>
										<td colspan="2" width="12%" align="right">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner != '0,00'">
												<h2>
													<xsl:call-template name="maakBedrag">
														<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
													</xsl:call-template>
												</h2>
											</xsl:if>
										</td>
										<td width="02%"/>
									</tr>
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner = '0,00'">
										<tr>
											<td colspan="2" width="25%"><h4>Totaal inkomen inclusief vakantiegeld</h4></td>
											<td colspan="2" width="12%" align="right">
											</td>
											<td colspan="2" width="12%" align="right">
												<h2>
													<xsl:call-template name="maakBedrag">
														<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
													</xsl:call-template>
												</h2>
											</td>
											<td width="02%"/>
										</tr>
									</xsl:if>
								</xsl:if>
								
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Schuldenaar = '0,00'">
									<tr>
										<td colspan="2" width="25%"><h4>Totaal inkomen inclusief vakantiegeld</h4></td>
										<td colspan="2" width="12%" align="right">
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar"/>
												</xsl:call-template>
											</h2>
										</td>
										<td colspan="2" width="12%" align="right">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner = '0,00'">
												<h2>
													<xsl:call-template name="maakBedrag">
														<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
													</xsl:call-template>
												</h2>
											</xsl:if>
										</td>
										<td width="02%"/>
									</tr>
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner != '0,00'">
										<tr>
											<td colspan="2" width="25%"><h4>Totaal inkomen inclusief vakantiegeld en eindejaarsuitkering</h4></td>
											<td colspan="2" width="12%" align="right">
											</td>
											<td colspan="2" width="12%" align="right">
												<h2>
													<xsl:call-template name="maakBedrag">
														<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
													</xsl:call-template>
												</h2>
											</td>
											<td width="02%"/>
										</tr>
									</xsl:if>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<!-- Gemeenschap van goederen of geen partner dan gewoon 1 regel altijd -->
								<tr>
									<td colspan="2" width="25%">
										<h4>
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Schuldenaar != '0,00'">
											Totaal inkomen inclusief vakantiegeld en eindejaarsuitkering
										</xsl:if>
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Schuldenaar = '0,00'">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner) &gt; 0">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner !='0,00'">
													Totaal inkomen inclusief vakantiegeld en eindejaarsuitkering
												</xsl:if>
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner ='0,00'">
													Totaal inkomen inclusief vakantiegeld
												</xsl:if>
											</xsl:if>
											<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner) = 0">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Geschatte_eindejaarsuitkering/Partner !='0,00'">
												Totaal inkomen inclusief vakantiegeld
												</xsl:if>
											</xsl:if>
										</xsl:if>								
										</h4>
									</td>
									<td colspan="2" width="12%" align="right">
										<h2>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar"/>
											</xsl:call-template>
										</h2>
									</td>
									<td colspan="2" width="12%" align="right">
										<h2>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
											</xsl:call-template>
										</h2>
									</td>
									<td width="02%"/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
						
						<tr>
							<td colspan="2" width="25%">&#160;</td>
							<td colspan="2" width="12%"/>
							<td colspan="2" width="12%"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">
								<h4>
									<strong>Totaal inkomen exclusief vakantiegeld</strong>
								</h4>
							</td>
							<td colspan="2" width="12%" align="right">
								<!-- als het vakantiegeld gevuld is, dan vermelden-->
								<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar )&gt;0">
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !=' '">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='0,00'">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='0'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='&#x0A;'">
													<h2>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
														</xsl:call-template>
													</h2>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<!-- als er geen inkomen is !(dus ook geen vakantiegeld), dan toch vermelden-->
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='0,00'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='0'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar =' '">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='&#x0A;'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<!-- als er gemeenschap is van goederen en bij schuldenaar is vakantiegeld niet gevuld, bij de partner wel, dan vermelden-->
								<!-- maar kan zijn dat het nu al vermeld wordt omdat de schuldenaar geen inkomen heeft?! dus dat uitsluiten-->
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar =' '">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='0,00'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='0'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='&#x0A;'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
							</td>
							<td colspan="2" width="12%" align="right">
								<!-- als het vakantiegeld gevuld is, dan vermelden-->
								<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
													<h2>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
														</xsl:call-template>
													</h2>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<!-- als er geen inkomen is !(dus ook geen vakantiegeld), dan toch vermelden-->
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='0,00'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='0'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner =' '">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='&#x0A;'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td colspan="2" width="25%">&#160;</td>
							<td colspan="2" width="12%"/>
							<td colspan="2" width="12%"/>
							<td width="02%"/>
						</tr>
					</tbody>
				</table>
				<!-- hier ALTIJD een pagebreak bij afdrukken -->
				<p>
					<br clear="left"/>
				</p>
				<div style="page-break-before: always"/>
				<!-- <div class="pagebreak"><P clear="left"/></div> -->
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td colspan="5" width="100%">
								<h4>Berekening geldig van&#160;</h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Berekening_Geldig_Van"/>
									</xsl:call-template>
								</h2>
								<h4>&#160;tot en met&#160;</h4>
								<h2>
									<xsl:call-template name="maakDatum">
										<xsl:with-param name="datum" select="VTLBCalculator/Berekening_Gegevens/Berekening_Geldig_Tm"/>
									</xsl:call-template>
								</h2>
							</td>
						</tr>
						<tr>
							<td width="58%">&#160;</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h3>Beslagvrije voet Rv</h3>
							</td>
							<td width="20%" align="right">
								<h4>
									<strong>Schuldenaar</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>Partner</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
											<h4>2/3 toepasselijke bijstandsnorm incl. VT</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Nee'">
											<h4>95% toepasselijke bijstandsnorm incl. VT</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
										<h4>2/3 toepasselijke bijstandsnorm incl. VT</h4>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<h4>95% toepasselijke bijstandsnorm incl. VT</h4>
								</xsl:if>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Percent95_Bijstandsnorm/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Percent95_Bijstandsnorm/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr bgcolor="#E0E0E0">
							<td width="58%">
								<h4>
									<strong>Beslagvrije voet Rv incl. VT</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--4.0.4 Informatief tonen voor de schuldenaar en de partner -->
						<tr>
							<td width="58%">
								<h4>Prijs verzorging / eigen bijdrage WLZ (inrichting)</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Eigen_Bijdrage_AWBZ/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
								<!-- Deze kolom mag hier weg -->
								<!-- 4.0.4 Kolom wel nodig -->
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Eigen_Bijdrage_AWBZ/Partner"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h3>
									<strong>Nominaal bedrag</strong>
								</h3>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
					</tbody>
				</table>
				
				
				
				
				
				
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="48%">
								<h4>Premie zorgverzekering</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Premie_Ziektekostenverzekering/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
								<!-- 
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Premie_Ziektekostenverzekering/Partner"/>
									</xsl:call-template>
								</h4>
								-->
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4>Aftrek van te ontvangen zorgtoeslag</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Zorgtoeslag/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
								<!-- 
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h4>
											-/- <xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Zorgtoeslag/Partner"/>
											</xsl:call-template>
										</h4>
									</xsl:if>
								</xsl:if>
								-->
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4>Normpremie bijstandsinkomen</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Normpremie_Ziektekostenverzekering/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
								<!--
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h4>
											-/- <xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Normpremie_Ziektekostenverzekering/Partner"/>
											</xsl:call-template>
										</h4>
									</xsl:if>
								</xsl:if>
								-->
							</td>
							<td width="12%"/>
						</tr>
					</tbody>
				</table>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="58%">
								<h4>
									<strong>Correctie ziektekosten: </strong>
									<xsl:value-of select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Indicatie_Correctie_Ziektekosten"/>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Correctie_Ziektekostenverzekering/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<!--
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Ziektekostenverzekering/Correctie_Ziektekostenverzekering/Partner"/>
									</xsl:call-template>
								</h2>
								-->
							</td>
							<td width="02%"/>
						</tr>
					</tbody>
				</table>
				<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar)&gt;0">
					<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!=' '">
						<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!='&#x0A;'">
							<table cellSpacing="0" width="100%" align="left">
								<tbody>
										<xsl:choose> <!-- Als los ongelijk aan opgeteld dan cursief tonen let op wel rekening houden met max servicekosten-->
											<xsl:when test="(number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar,',','.'))+number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/MaxServicekosten/Schuldenaar,',','.')))=number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Huur_Max/Schuldenaar,',','.'))">
												<tr>
													<td width="48%">
														<h4>Kale huur per maand</h4>
													</td>
													<td width="20%" align="right">
														<h4>
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="20%" align="right">
														<h4>
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Partner"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="12%"/>
												</tr>
												<tr>
													<td width="48%">
														<h4>Servicekosten per maand</h4>
													</td>
													<td width="20%" align="right">
														<h4>
															+  <xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Servicekosten/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="20%" align="right">
														<!--
														<h4>
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Servicekosten/Partner"/>
															</xsl:call-template>
														</h4>
														-->
													</td>
													<td width="12%"/>
												</tr>
											</xsl:when>
											<xsl:otherwise>
												<tr>
													<td width="48%">
														<h4 class="grayitalic">Kale huur per maand</h4>
													</td>
													<td width="20%" align="right">
														<h4 class="grayitalic">
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="20%" align="right">
														<h4 class="grayitalic">
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Partner"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="12%"/>
												</tr>
												<tr>
													<td width="48%">
														<h4 class="grayitalic">Servicekosten per maand</h4>
													</td>
													<td width="20%" align="right">
														<h4 class="grayitalic">
															+  <xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Servicekosten/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="20%" align="right">
														<!--
														<h4>
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Servicekosten/Partner"/>
															</xsl:call-template>
														</h4>
														-->
													</td>
													<td width="12%"/>
												</tr>
												<tr>
													<td width="48%">
														<h4 class="grayitalic">Totale woonlasten + max.  <xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/MaxServicekosten/Schuldenaar"/>
															</xsl:call-template>&#160;servicekosten
														</h4>
													</td>
													<td width="20%" align="right">
														<h4 class="grayitalic">
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Huur/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</td>
													<td width="20%" align="right">
														<!--
														<h4 class="grayitalic">
															<xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Huur/Partner"/>
															</xsl:call-template>
														</h4>
														-->
													</td>
													<td width="12%"/>
												</tr>
											</xsl:otherwise>
										</xsl:choose>
									<!--
									<tr>
										<td width="48%"/>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!='&#x0A;'">
														<h4>
															<strong>__________</strong>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
									-->
									<tr>
										<td width="48%">
											<h4>
												Max. huurgrens/kale huur + max. <xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/MaxServicekosten/Schuldenaar"/>
												</xsl:call-template>&#160;servicekosten
											</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Huur_Max/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
									<tr>
										<td width="48%">
											<h4>Ondergrens voor huur</h4>
										</td>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!='&#x0A;'">
														<h4>
															-/- <xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Minimum_Normhuur/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
									<tr>
										<td width="48%">
											<h4>Ontvangen huurtoeslag</h4>
										</td>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Kale_Huur/Schuldenaar!='&#x0A;'">
														<h4>
															-/- <xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Ontvangen_Huurtoeslag/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
								</tbody>
							</table>
							<table cellSpacing="0" width="100%" align="left">
								<tbody>
									<tr>
										<td width="58%">
											<h4>
												<strong>Correctie woonlasten huurwoning: </strong>
												<xsl:value-of select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Indicatie_Correctie_Woonlasten"/>
											</h4>
										</td>
										<td width="20%" align="right">
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Correctie_Woonlasten/Schuldenaar"/>
												</xsl:call-template>
											</h2>
										</td>
										<td width="20%" align="right">
											<!-- 
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Huurwoning/Correctie_Woonlasten/Partner"/>
												</xsl:call-template>
											</h2>
											-->
										</td>
										<td width="02%"/>
									</tr>
								</tbody>
							</table>
						</xsl:if>
					</xsl:if>
				</xsl:if>

						
				<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
					<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
						<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
							<table cellSpacing="0" width="100%" align="left">
								<tbody>
									<xsl:choose>
										<xsl:when test="(number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar,',','.'))+number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Schuldenaar,',','.')))=number(translate(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Kosten_Eigen_Woning_Max/Schuldenaar,',','.'))">
											<tr>
												<td width="48%">
													<h4>Hypotheekrente en erfpacht per maand</h4>
												</td>
												<td width="20%" align="right">
													<h4>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="20%" align="right">
													<!-- Deze kolom mag hier weg -->
													<h4>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Partner"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="12%"/>
											</tr>
											<tr>
												<td width="48%">
													<h4>Overige kosten eigen woning (</h4>
													<h2>
														<xsl:call-template name="maakBedrag2">
															<xsl:with-param name="bedrag2" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZPercentage"/>
														</xsl:call-template>
													</h2>
													<h4>&#160;% van </h4>
													<h2>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZWaarde"/>
														</xsl:call-template>
													</h2>
													<h4>)</h4>
												</td>
												<td width="20%" align="right">
													<h4>
														+  <xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Schuldenaar"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="20%" align="right">
													<!-- 
													<h4>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Partner"/>
														</xsl:call-template>
													</h4>
													-->
												</td>
												<td width="12%"/>
											</tr>
											<!--
											<tr>
												<td width="48%"/>
												<td width="20%" align="right">
													<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
														<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
															<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
																<h4>
																	<strong>__________</strong>
																</h4>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</td>
												<td width="20%"/>
												<td width="12%"/>
											</tr>
											-->
										</xsl:when>	
										<xsl:otherwise>
											<tr>
												<td width="48%">
													<h4 class="grayitalic">Hypotheekrente en erfpacht per maand</h4>
												</td>
												<td width="20%" align="right">
													<h4 class="grayitalic">
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="20%" align="right">
													<!-- Deze kolom mag hier weg -->
													<h4 class="grayitalic">
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Partner"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="12%"/>
											</tr>
											<tr>
												<td width="48%">
													<h4 class="grayitalic">Overige kosten eigen woning (</h4>
													<h2 class="grayitalic">
														<xsl:call-template name="maakBedrag2">
															<xsl:with-param name="bedrag2" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZPercentage"/>
														</xsl:call-template>
													</h2>
													<h4 class="grayitalic">&#160;% van </h4>
													<h2 class="grayitalic">
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/WOZWaarde"/>
														</xsl:call-template>
													</h2>
													<h4 class="grayitalic">)</h4>
												</td>
												<td width="20%" align="right">
													<h4 class="grayitalic">
														+  <xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Schuldenaar"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="20%" align="right">
													<!-- 
													<h4>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Overige_Kosten/Partner"/>
														</xsl:call-template>
													</h4>
													-->
												</td>
												<td width="12%"/>
											</tr>
											<tr>
												<td width="48%">
													<h4 class="grayitalic">Totale woonlasten</h4>
												</td>
												<td width="20%" align="right">
													<h4 class="grayitalic">
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Kosten_Eigen_Woning/Schuldenaar"/>
														</xsl:call-template>
													</h4>
												</td>
												<td width="20%" align="right">
													<!-- Deze kolom mag hier weg -->
													<!--
													<h4 class="grayitalic">
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Kosten_Eigen_Woning/Schuldenaar"/>
														</xsl:call-template>
													</h4>
													-->
												</td>
												<td width="12%"/>
											</tr>
											<!--
											<tr>
												<td width="48%"/>
												<td width="20%" align="right">
													<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
														<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
															<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
																<h4>
																	<strong>__________</strong>
																</h4>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</td>
												<td width="20%"/>
												<td width="12%"/>
											</tr>
											-->
										</xsl:otherwise>
									</xsl:choose>
									<tr>
										<td width="48%">
											<h4>Maximale kosten eigen woning</h4>
										</td>
										<td width="20%" align="right">
											<h4>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Kosten_Eigen_Woning_Max/Schuldenaar"/>
												</xsl:call-template>
											</h4>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
									<tr>
										<td width="48%">
											<h4>Minimum normhuur</h4>
										</td>
										<td width="20%" align="right">
											<xsl:if test="string-length(VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar)&gt;0">
												<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!=' '">
													<xsl:if test="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Hypotheekrente_Erfpacht/Schuldenaar!='&#x0A;'">
														<h4>
															-/- <xsl:call-template name="maakBedrag">
																<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Minimum_Normhuur/Schuldenaar"/>
															</xsl:call-template>
														</h4>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
										<td width="20%"/>
										<td width="12%"/>
									</tr>
								</tbody>
							</table>
							<table cellSpacing="0" width="100%" align="left">
								<tbody>
									<tr>
										<td width="58%">
											<h4>
												<strong>Correctie woonlasten eigen woning: </strong>
												<xsl:value-of select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Indicatie_Correctie_Woonlasten"/>
											</h4>
										</td>
										<td width="20%" align="right">
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Correctie_Woonlasten/Schuldenaar"/>
												</xsl:call-template>
											</h2>
										</td>
										<td width="20%" align="right">
											<!-- 
											<h2>
												<xsl:call-template name="maakBedrag">
													<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Verhoging_Woonkosten_Eigenwoning/Correctie_Woonlasten/Partner"/>
												</xsl:call-template>
											</h2>
											-->
										</td>
										<td width="02%"/>
									</tr>
								</tbody>
							</table>
						</xsl:if>
					</xsl:if>
				</xsl:if>


				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="48%">
								<h4>Kindgebonden budget maximaal</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Maximaal/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%"/>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4>Ontvangen kindgebonden budget</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Ontvangen/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%"/>
							<td width="12%"/>
						</tr>
					</tbody>
				</table>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="58%">
								<h4>
									<strong>Correctie kindgebonden budget: </strong>
									<xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/Indicatie_KingebondenBudget_Correctie"/>
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:choose>
								<xsl:when test="number(translate(VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Correctie/Schuldenaar,',','.'))&lt;0">
								<h2 class="red">
									<xsl:call-template name="maakBedragSpeciaal">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Correctie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
								</xsl:when>
								<xsl:otherwise>
								<h2>
									<xsl:call-template name="maakBedragSpeciaal">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Correctie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
								</xsl:otherwise>
								</xsl:choose>
							</td>
							<td width="20%" align="right">
								<!-- 
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/KindgebondenBudget/KindgebondenBudget_Correctie/Partner"/>
									</xsl:call-template>
								</h2>
								-->
							</td>
							<td width="20%"/>
						</tr>
					</tbody>
				</table>
				
				
				
				
				
				
				
				
				<!-- hier stond de pagebreak-->
				<div>
					<br clear="left"/>
				</div>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<!--
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
								-->
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Totaal aan correcties  (A)</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Totaal_aan_correcties/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<!--
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Totaal_aan_correcties/Partner"/>
									</xsl:call-template>
								</h2>
								-->
							</td>
							<td width="02%"/>
						</tr>
						<!-- Onder “totaal aan correcties” witregel toevoegen -->
						<tr>
							<td width="58%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
					</tbody>
				</table>
				
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<!-- 4.0.4 -->
						<!-- Max BVV alleen gevuld indien van toepassing -->
						<xsl:choose>
							<xsl:when test="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Max_BVV/Schuldenaar != '0,00'">
						
						<tr>
							<td width="48%">
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
											<h4 class="grayitalic">Beslagvrije voet Rv incl. VT zonder verhoging</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Nee'">
											<h4 class="grayitalic">Berekende beslagvrije voet Rv incl. VT</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
										<h4 class="grayitalic">Beslagvrije voet Rv incl. VT zonder verhoging</h4>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<h4 class="grayitalic">Berekende beslagvrije voet Rv incl. VT</h4>
								</xsl:if>
							</td>
							<td width="20%" align="right">
								<h4 class="grayitalic">
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/BVV/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4 class="grayitalic">Correctie i.v.m. tijdelijke verhoging beslagvrije voet</h4>
							</td>
							<td width="20%" align="right">
								<h4 class="grayitalic">
									-  <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4 class="grayitalic">Correctie auto van de zaak</h4>
							</td>
							<td width="20%" align="right">
								<h4 class="grayitalic">
									+  <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Correctie_auto/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						</xsl:when>
						<xsl:otherwise>
						
						<tr>
							<td width="48%">
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
											<h4>Beslagvrije voet Rv incl. VT zonder verhoging</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Nee'">
											<h4>Beslagvrije voet Rv incl. VT</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
										<h4>Beslagvrije voet Rv incl. VT zonder verhoging</h4>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<h4>Beslagvrije voet Rv incl. VT</h4>
								</xsl:if>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/BVV/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4>Correctie i.v.m. tijdelijke verhoging beslagvrije voet</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									-  <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Algemeen_Wonen/Wooncorrectie_BVV"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						<tr>
							<td width="48%">
								<h4>Correctie auto van de zaak</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									+  <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Correctie_auto/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
						</xsl:otherwise>
						</xsl:choose>
						<!-- Max BVV alleen gevuld indien van toepassing -->
						<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Max_BVV/Schuldenaar != '0,00'">
							<tr>
								<td width="48%">
									<h4>Maximale beslagvrije voet Rv incl. VT</h4>
								</td>
								<td width="20%" align="right">
									<h4>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Max_BVV/Schuldenaar"/>
										</xsl:call-template>
									</h4>
								</td>
								<td width="20%" align="right"/>
								<td width="12%"/>
							</tr>
						</xsl:if>
						<tr>
							<td width="48%">
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Ja'">
											<h4>2/3 toepasselijke bijstandsnorm</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Partner_Gegevens/Opgenomen_In_Inrichting='Nee'">
											<h4>95% toepasselijke bijstandsnorm</h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Nee'">
										<h4>2/3 toepasselijke bijstandsnorm</h4>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Schuldenaar_Gegevens/Opgenomen_In_Inrichting='Nee'">
									<h4>95% toepasselijke bijstandsnorm</h4>
								</xsl:if>
							</td>
							<td width="20%" align="right">
								<h4>
									-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Toepasselijke_bijstandsnorm_95/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="12%"/>
						</tr>
					</tbody>
				</table>
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<!--
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
								-->
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Compensatiekop  (B)</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Compensatiekop/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<!-- 
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Berekening_compensatiekop/Compensatiekop/Partner"/>
											</xsl:call-template>
										</h2>
									</xsl:if>
								</xsl:if>
								-->
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>
									==========
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										==========
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<!-- 4.0.4 -->
						<tr>
							<td width="58%">
								<h4>
									<strong>Correctie individuele lasten  (A-B): </strong>
									<xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Indicatie_Correctie_individuele_lasten"/>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Correctie_individuele_lasten/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_individuele_lasten/Correctie_individuele_lasten/Partner"/>
											</xsl:call-template>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<!-- Onder “correctie individuele lasten” een witregel toevoegen 
						toch niet
						toch wel -->
						<tr>
							<td width="58%">
								<p>
									<br clear="left"/>
								</p>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<!-- 4.0.4 -->
					</tbody>
				</table>
				
				
				
				<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Indicatie_Extra_correctie_PGL='Ja'">
					<table cellSpacing="0" width="100%" align="left">
						<tbody>
							<tr>
								<td width="58%">
									<h4>95% pensioengerechtigd norm</h4>
								</td>
								<td width="20%" align="right">
									<h4>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Pensioengerechtigd_norm_95/Schuldenaar"/>
										</xsl:call-template>
									</h4>
								</td>
								<td width="20%"/>
								<td width="02%"/>
							</tr>
							<tr>
								<td width="58%">
									<h4>95% norm</h4>
								</td>
								<td width="20%" align="right">
									<h4>
										-/- <xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Norm_95/Schuldenaar"/>
										</xsl:call-template>
									</h4>
								</td>
								<td width="20%"/>
								<td width="02%"/>
							</tr>
							<!-- Witregel met enkele streep boven extra correctie pensioengerechtigd weghalen
							<tr>
								<td width="58%"/>
								<td width="20%" align="right">
									<h4>
										<strong>__________</strong>
									</h4>
								</td>
								<td width="20%" align="right">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<h4>
											<strong>__________</strong>
										</h4>
									</xsl:if>
								</td>
								<td width="02%"/>
							</tr>
							-->
							<tr>
								<td width="58%">
									<h4>
										<strong>Correctie pensioengerechtigde norm: </strong>
										<xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Indicatie_Extra_correctie_PGL"/>
									</h4>
								</td>
								<td width="20%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Extra_correctie_PGL/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="20%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Extra_correctie_pensioen/Extra_correctie_PGL/Partner"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="02%"/>
							</tr>
						</tbody>
					</table>
				</xsl:if>
				
				
				<table cellSpacing="0" width="100%" align="left">
					<tbody>
						<!-- 2.8.1 Vervallen
						<tr>
							<td width="58%">
								<h4>Overheveling beslagvrije voet</h4>
							</td>
							<td width="20%" align="right">
								<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_BeslagVrijeVoet/Schuldenaar"/></xsl:call-template></h2>
							</td>
							<td width="20%" align="right">
								<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_BeslagVrijeVoet/Partner"/></xsl:call-template></h2>
							</td>
							<td width="02%"/>
						</tr>
						-->
						<!-- 4.0.4 wel als persoon in inrichting-->
						<!-- m*4.7 Reserveringstoeslag alleen zichtbaar als gevuld -->
						<!-- hoef alleen schuldenaar te controleren want je kunt niet alleen partner in inrichting hebben -->
						<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Reserveringstoeslag/Schuldenaar !='0,00'">
							<tr>
								<td width="58%">
									<h4>Reserveringstoeslag (alleen bij norm inrichting)</h4>
								</td>
								<td width="20%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Reserveringstoeslag/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="20%" align="right">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Reserveringstoeslag/Partner"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="02%"/>
							</tr>
						</xsl:if>
						<tr>
							<td width="58%">
								<h4>Arbeidstoeslag</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Arbeidstoeslag/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Arbeidstoeslag/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Zorgverzekering max. verplicht eigen risico (per maand)</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Ziektekosten_Verplicht_Eigen_Risico/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Ziektekosten_Verplicht_Eigen_Risico/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Woonlasten boven max. huurtoeslaggrens</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Woonkosten_Boven_Max_Huurtoeslag/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Woonkosten_Boven_Max_Huurtoeslag/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!-- 4.0.4 woonkosten onder minimum normhuur is niet meer van toepassing
						<tr>
							<td width="58%">
								<h4>Woonkosten onder minimum normhuur</h4>
							</td>
							<td width="20%" align="right">
								<h2>-/- <xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Woonkosten_Onder_Minimum/Schuldenaar"/></xsl:call-template></h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>-/- <xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Woonkosten_Onder_Minimum/Partner"/></xsl:call-template></h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						-->
						<tr>
							<td width="58%">
								<h4>
									<strong>Auto- en reiskosten</strong>
								</h4>
							</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Op basis van forfait (<xsl:call-template name="maakNummer">
										<xsl:with-param name="nummer" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Forfait_Aantal/Km_Schuldenaar"/>
									</xsl:call-template>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										/ <xsl:call-template name="maakNummer">
											<xsl:with-param name="nummer" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Forfait_Aantal/Km_Partner"/>
										</xsl:call-template>
									</xsl:if>&#160;km per jaar)</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Forfait/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Forfait/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Op basis van aantal km per jaar (<xsl:call-template name="maakNummer">
										<xsl:with-param name="nummer" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Aantal_Km_Aantal/Km_Schuldenaar"/>
									</xsl:call-template>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										/ <xsl:call-template name="maakNummer">
											<xsl:with-param name="nummer" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Aantal_Km_Aantal/Km_Partner"/>
										</xsl:call-template>
									</xsl:if>&#160;km per jaar)</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Aantal_Km/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Basis_Aantal_Km/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Andere reiskosten</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Andere_Reiskosten/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Auto_En_Reiskosten/Andere_Reiskosten/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Kosten kinderopvang</strong> totaal</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Kosten_Kinderopvang/Totale_Kosten_Kinderopvang/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Kinderopvangtoeslag en tegemoetkoming UWV/gemeente</h4>
							</td>
							<td width="20%" align="right">
								<h4>-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Kosten_Kinderopvang/Toeslag_Kinderopvang/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<!-- Witregel met enkele streep boven correctie voor rekening van weghalen (zowel bij kinderopvang als bij studiekosten)
						<tr>
							<td width="25%"/>
							<td width="25%"/>
							<td width="20%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						-->
						<tr>
							<td width="58%">
								<h4>Correctie voor rekening van</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Kosten_Kinderopvang/Correctie_Kinderopvang/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Kosten_Kinderopvang/Correctie_Kinderopvang/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Studiekosten</strong> max. tegemoetkoming (incl. basiscor. <h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Studiekosten/Studiekosten_Basiscorrectie"/>
										</xsl:call-template>
									</h2>)</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Studiekosten/Tegemoetkoming_Studiekosten_Kinderen/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Ontvangen tegemoetkoming in de studiekosten</h4>
							</td>
							<td width="20%" align="right">
								<h4>-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Studiekosten/Ontvangen_Tegemoetkoming_Studiekosten/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
							</td>
							<td width="02%"/>
						</tr>
						<!-- Witregel met enkele streep boven correctie voor rekening van weghalen (zowel bij kinderopvang als bij studiekosten)
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						-->
						<tr>
							<td width="58%">
								<h4>Correctie voor rekening van</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Studiekosten/Correctie_Studiekosten/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Studiekosten/Correctie_Studiekosten/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Alimentatie</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Alimentatie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Alimentatie/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Beschermingsbewind/budgetbeheer</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/BeschermBudgetCorrectie/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/BeschermBudgetCorrectie/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>
									<strong>Overige correcties</strong>
								</h4>
							</td>
							<!-- De a of de b moet alleen zichtbaar zijn als er een bedrag is ingevuld. -->
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Correcties/Schuldenaar !='0,00'">
									<h2>a)&#160;&#160;&#160;&#160;&#160;&#160;</h2>
								</xsl:if>
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Correcties/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Correcties/Partner !=''">
										<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Correcties/Partner !='0,00'">
											<h2>b)&#160;&#160;&#160;&#160;&#160;&#160;</h2>
										</xsl:if>
									</xsl:if>
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Correcties/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<tr>
								<td width="58%">
									<h4>
										<strong>Gezamenlijke overige correcties</strong>
									</h4>
								</td>
								<!-- De c moet alleen zichtbaar zijn als er een bedrag is ingevuld. -->
								<td width="20%" align="right">
									<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Correcties/Schuldenaar !='0,00'">
										<h2>c)&#160;&#160;&#160;&#160;&#160;&#160;</h2>
									</xsl:if>
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Correcties/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</td>
								<td width="20%" align="right">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Correcties/Partner !=''">
										<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Correcties/Partner !='0,00'">
											<h2>c)&#160;&#160;&#160;&#160;&#160;&#160;</h2>
										</xsl:if>
										</xsl:if>
										<h2>
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Correcties/Partner"/>
											</xsl:call-template>
										</h2>
									</xsl:if>
								</td>
								<td width="02%"/>
							</tr>
						</xsl:if>
						<tr>
							<td width="58%">
								<h4>
									<strong>Totale overheveling</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<!-- 3.0.1 Hier moet dus een # komen als de indicatie aanstaat -->
								<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_Indicatie='Ja'">
									<h6>
										<strong>
											<xsl:value-of select="'&#35;&#160;'"/>
										</strong>
									</h6>
								</xsl:if>
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_Totaal/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<!-- 3.0.1 Hier moet dus een # komen als de indicatie aanstaat -->
								<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_Indicatie='Ja'">
									<h6>
										<strong>
											<xsl:value-of select="'&#35;&#160;'"/>
										</strong>
									</h6>
								</xsl:if>
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overheveling_Totaal/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>
									<strong>__________</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>
										<strong>__________</strong>
									</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<!-- <tr bgcolor="#E0E0E0"> m*4.6 grijze achtergrond weg (e-mail Pauline Mon 08/01/2024 15:34) -->
						<tr>
							<td width="58%">
								<h4>
									<strong>Nominaal bedrag</strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Nominaal_Bedrag/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Nominaal_Bedrag/Nominaal_Bedrag/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<!--m*4.6 regel erbij altijd -->
						<tr>
							<td width="58%">
								<h4>
									Beslagvrije voet Rv incl. VT 
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>+ 
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>+ 
											<xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Partner"/>
											</xsl:call-template>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr bgcolor="#E0E0E0">
							<td width="58%">
								<h4>Beslagvrije voet plus nominaal bedrag en overheveling</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/VTLB_Totalen/Beslagvrije_Voet_Plus_Nominaal/Schuldenaar=VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Schuldenaar">
									<h4>(bvv) </h4>
								</xsl:if>
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Beslagvrije_Voet_Plus_Nominaal/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<xsl:if test="VTLBCalculator/VTLB_Totalen/Beslagvrije_Voet_Plus_Nominaal/Partner=VTLBCalculator/VTLB_Beslagvrije_Voet/Beslagvrije_Voet/Partner">
											<h4>(bvv) </h4>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<h2>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Beslagvrije_Voet_Plus_Nominaal/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Maandelijks te reserveren vakantiegeld</h4>
							</td>
							<td width="20%" align="right">
								<h2>-/- <xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/In_Te_Houden_Vakantiegeld/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
										<h2>-/- <xsl:call-template name="maakBedrag">
												<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/In_Te_Houden_Vakantiegeld/Partner"/>
											</xsl:call-template>
										</h2>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%"/>
							<td width="20%" align="right">
								<h4>==========</h4>
							</td>
							<td width="20%" align="right">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
									<h4>==========</h4>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>

						<tr>
							<td width="58%">
								<h4>
									<!-- m*4.6 tekst uit xml -->
									<strong><xsl:value-of select="VTLBCalculator/VTLB_Totalen/Tekst_Vrij_Te_Laten_Bedrag"/></strong>
								</h4>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
											<xsl:if test="VTLBCalculator/Gezinssituatie/Samen_In_Regeling='Ja'">
												<xsl:call-template name="Vergelijk1">
													<xsl:with-param name="Eerste" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Schuldenaar"/>
													<xsl:with-param name="Tweede" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar"/>
												</xsl:call-template>
											</xsl:if>
										</xsl:if>
									</xsl:if>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Schuldenaar"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="20%" align="right">
								<h2>
									<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
										<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
											<xsl:if test="VTLBCalculator/Gezinssituatie/Samen_In_Regeling='Ja'">
												<xsl:call-template name="Vergelijk1">
													<xsl:with-param name="Eerste" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Partner"/>
													<xsl:with-param name="Tweede" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
												</xsl:call-template>
											</xsl:if>
										</xsl:if>
									</xsl:if>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Partner"/>
									</xsl:call-template>
								</h2>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<!-- m*4.6 tekst uit xml -->
								<h4><xsl:value-of select="VTLBCalculator/VTLB_Totalen/Te_behouden_vakantiegeld"/></h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Te_Behouden_Vakantiegeld/Schuldenaar"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="20%" align="right">
								<h4>
									<xsl:call-template name="maakBedrag">
										<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Totalen/Te_Behouden_Vakantiegeld/Partner"/>
									</xsl:call-template>
								</h4>
							</td>
							<td width="02%"/>
						</tr>
						<tr>
							<td width="58%">
								<h4>Totaal inkomen exclusief vakantiegeld</h4>
							</td>
							<td width="20%" align="right">
								<!-- als het vakantiegeld gevuld is, dan vermelden-->
								<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar )&gt;0">
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !=' '">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='0,00'">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='0'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar !='&#x0A;'">
													<h2>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
														</xsl:call-template>
													</h2>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<!-- als er geen inkomen is !(dus ook geen vakantiegeld), dan toch vermelden-->
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='0,00'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='0'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar =' '">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar ='&#x0A;'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<!-- als er gemeenschap is van goederen en bij schuldenaar is vakantiegeld niet gevuld, bij de partner wel, dan vermelden-->
								<!-- maar kan zijn dat het nu al vermeld wordt omdat de schuldenaar geen inkomen heeft?! dus dat uitsluiten-->
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar =' '">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='0,00'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='0'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
									<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar)&gt;0">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !=' '">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0,00'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='0'">
													<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar !='&#x0A;'">
														<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Schuldenaar ='&#x0A;'">
															<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
																<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
																	<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
																		<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
																			<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
																				<h2>
																					<xsl:call-template name="maakBedrag">
																						<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Schuldenaar"/>
																					</xsl:call-template>
																				</h2>
																			</xsl:if>
																		</xsl:if>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
							</td>
							<td width="20%" align="right">
								<!-- als het vakantiegeld gevuld is, dan vermelden-->
								<xsl:if test="string-length(VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner )&gt;0">
									<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !=' '">
										<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0,00'">
											<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='0'">
												<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Vakantiegeld/Partner !='&#x0A;'">
													<h2>
														<xsl:call-template name="maakBedrag">
															<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
														</xsl:call-template>
													</h2>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<!-- als er geen inkomen is !(dus ook geen vakantiegeld), dan toch vermelden-->
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='0,00'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='0'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner =' '">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
								<xsl:if test="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner ='&#x0A;'">
									<h2>
										<xsl:call-template name="maakBedrag">
											<xsl:with-param name="bedrag" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen_ExVT/Partner"/>
										</xsl:call-template>
									</h2>
								</xsl:if>
							</td>
							<td width="02%"/>
						</tr>
						<!-- m*4.7 1 vaste lege regel voor de toelichtingen -->
						<tr>
							<td width="58%">&#160;</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						<!-- m*4.7 lege regel weg
						<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Schuldenaar_Tekst=''">
							<tr>
								<td width="58%">&#160;</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="02%"/>
							</tr>
						</xsl:if>
						-->
						<!-- m*4.7 lege regel weg
						<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Partner_Tekst=''">
							<tr>
								<td width="58%">&#160;</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="02%"/>
							</tr>
						</xsl:if>
						-->
						<xsl:if test="string-length(VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Schuldenaar_Tekst)&gt;0">
							<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Schuldenaar_Tekst!=' '">
								<tr>
									<td colspan="5" width="100%">
										<h4>a) <xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Schuldenaar_Tekst"/>
										<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Ja'">
											&#160;<xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Partner_Tekst"/>
										</xsl:if>
										</h4>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen!='Ja'">
							<xsl:if test="string-length(VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Partner_Tekst)&gt;0">
								<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Partner_Tekst!=' '">
									<tr>
										<td colspan="5" width="100%">
											<h4>b) <xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Overige_Toelichting/Partner_Tekst"/>
											</h4>
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<!-- m*4.7 lege regel weg
						<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Toelichting/Schuldenaar_Tekst=''">
							<tr>
								<td width="58%">&#160;</td>
								<td width="20%"/>
								<td width="20%"/>
								<td width="02%"/>
							</tr>
						</xsl:if>
						-->
						<xsl:if test="string-length(VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Toelichting/Schuldenaar_Tekst)&gt;0">
							<xsl:if test="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Toelichting/Schuldenaar_Tekst!=' '">
								<tr>
									<td colspan="5" width="100%">
										<h4>c) <xsl:value-of select="VTLBCalculator/VTLB_Nominaal_Bedrag/Gezamenlijke_Overige_Toelichting/Schuldenaar_Tekst"/>
										</h4>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
						<!-- m*4.6 tekst Uit xml -->
						<xsl:if test="string-length(VTLBCalculator/VTLB_Totalen/Tekst_Let_Op_juli2023) &gt; 0">
								<tr>
									<td colspan="5" width="100%">
										<h4><xsl:value-of select="VTLBCalculator/VTLB_Totalen/Tekst_Let_Op_juli2023"/></h4>
									</td>
								</tr>
						</xsl:if>
						<xsl:if test="VTLBCalculator/Gezinssituatie/Partner_Aanwezig='Ja'">
							<xsl:if test="VTLBCalculator/Gezinssituatie/Gemeenschap_Van_Goederen='Nee'">
								<xsl:if test="VTLBCalculator/Gezinssituatie/Samen_In_Regeling='Ja'">
									<tr>
										<td colspan="5" width="100%">
											<h4>
												<xsl:call-template name="Vergelijk2">
													<xsl:with-param name="Eerste" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Schuldenaar"/>
													<xsl:with-param name="Tweede" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Schuldenaar"/>
													<xsl:with-param name="Derde" select="VTLBCalculator/VTLB_Totalen/Vrij_Te_Laten_Bedrag/Partner"/>
													<xsl:with-param name="Vierde" select="VTLBCalculator/VTLB_Inkomsten/Totaal_Inkomen/Partner"/>
												</xsl:call-template>
											</h4>
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<xsl:if test="not(VTLBCalculator/VTLB_Algemeen/Jaartal_huwelijk='')">
							<tr>
								<td colspan="5" width="100%">
									<!-- m*4.6 aanpassing tekst -->
									<h4>
										Let op: hier is sprake van een huwelijk in beperkte gemeenschap van goederen gesloten na 1 januari 2018. De afloscapaciteit moet verdeeld worden volgens de regels van het huidige huwelijksvermogensrecht. Meer informatie staat in de "handleiding voor de berekening van het vtlb" op de website van Bureau Wsnp.
									</h4>
								</td>
							</tr>
						</xsl:if>
						<!-- m*4.7 lege regel weg
						<tr>
							<td width="58%">&#160;</td>
							<td width="20%"/>
							<td width="20%"/>
							<td width="02%"/>
						</tr>
						-->
					
				</tbody>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="maakDatum">
		<xsl:param name="datum"/>
		<xsl:param name="Jaar" select="substring($datum,1,4)"/>
		<xsl:param name="Maand" select="substring($datum,6,2)"/>
		<xsl:param name="Dag" select="substring($datum,9,2)"/>
		<xsl:value-of select="$Dag"/>
		<xsl:if test="$Dag&gt;0">
			<xsl:text>-</xsl:text>
		</xsl:if>
		<xsl:value-of select="$Maand"/>
		<xsl:if test="$Maand&gt;0">
			<xsl:text>-</xsl:text>
		</xsl:if>
		<xsl:if test="$Jaar&gt;0">
			<xsl:value-of select="$Jaar"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakBedrag">
		<xsl:param name="bedrag"/>
		<xsl:param name="temp" select="translate($bedrag,',','.')"/>
		<xsl:if test="string-length($bedrag)&gt;0">
			<xsl:if test="$bedrag!=' '">
				<xsl:if test="$bedrag!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,00;-#.##0,00','getal')"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakBedragSpeciaal">
		<xsl:param name="bedrag"/>
		<xsl:param name="temp" select="translate($bedrag,',','.')"/>
		<xsl:if test="string-length($bedrag)&gt;0">
			<xsl:if test="$bedrag!=' '">
				<xsl:if test="$bedrag!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,00;-#.##0,00 !','getal')"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakBedrag2">
		<xsl:param name="bedrag2"/>
		<xsl:param name="temp" select="translate($bedrag2,',','.')"/>
		<xsl:if test="string-length($bedrag2)&gt;0">
			<xsl:if test="$bedrag2!=' '">
				<xsl:if test="$bedrag2!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,000;-#.##0,000','getal')"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakBedrag3">
		<xsl:param name="bedrag3"/>
		<xsl:param name="temp" select="translate($bedrag3,',','.')"/>
		<xsl:if test="string-length($bedrag3)&gt;0">
			<xsl:if test="$bedrag3!=' '">
				<xsl:if test="$bedrag3!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,0000;-#.##0,0000','getal')"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakNummer">
		<xsl:param name="nummer"/>
		<xsl:if test="string-length($nummer)&gt;0">
			<xsl:if test="$nummer!=' '">
				<xsl:if test="$nummer!='&#x0A;'">
					<xsl:value-of select="format-number($nummer,'#.###.##0;-#.###.##0','getal')"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="maakPostcode">
		<xsl:param name="postcode"/>
		<xsl:value-of select="substring($postcode,1,4)"/>
		<xsl:text><![CDATA[ ]]></xsl:text>
		<xsl:value-of select="substring($postcode,5,2)"/>
	</xsl:template>
	
	<!--m*4.6 toch niet gebruikt maar laten staan mocht het ooit nodig zijn -->
	<xsl:template name="VergelijkDatum">
		<xsl:param name="datum1"/>
		<xsl:param name="datum2"/>

		<xsl:variable name="Jaar1" select="substring($datum1,1,4)"/>
		<xsl:variable name="Maand1" select="substring($datum1,6,2)"/>
		<xsl:variable name="Dag1" select="substring($datum1,9,2)"/>
		<xsl:variable name="Jaar2" select="substring($datum2,1,4)"/>
		<xsl:variable name="Maand2" select="substring($datum2,6,2)"/>
		<xsl:variable name="Dag2" select="substring($datum2,9,2)"/>

		<xsl:variable name="date1" select="10000 * $Jaar1 + 100 * $Maand1 + $Dag1"/>
		<xsl:variable name="date2" select="10000 * $Jaar2 + 100 * $Maand2 + $Dag2"/>
		<xsl:choose>
			<xsl:when test="$date1 &gt; $date2">
				<!-- code for dates later than datumint  -->
				<xsl:text>1</xsl:text>
			</xsl:when>
			<xsl:when test="$date1 &lt; $date2">
				<!-- code for dates earlier than datumint  -->
				<xsl:text>-1</xsl:text>
			</xsl:when>
			<xsl:otherwise>
			<!-- code for dates equal to datumint -->
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Vergelijk1">
		<xsl:param name="Eerste"/>
		<xsl:param name="Tweede"/>
		<xsl:param name="temp1" select="translate($Eerste,',','.')"/>
		<xsl:param name="temp2" select="translate($Tweede,',','.')"/>
		<xsl:if test="string-length($Eerste)&gt;0">
			<xsl:if test="$Eerste!=' '">
				<xsl:if test="$Eerste!='&#x0A;'">
					<xsl:if test="string-length($Tweede)&gt;0">
						<xsl:if test="$Tweede!=' '">
							<xsl:if test="$Tweede!='&#x0A;'">
								<xsl:if test="number($temp1)&gt;number($temp2)">
									<xsl:value-of select="'&#42;&#160;'"/>
								</xsl:if>
							</xsl:if>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Vergelijk2">
		<xsl:param name="Eerste"/>
		<xsl:param name="Tweede"/>
		<xsl:param name="Derde"/>
		<xsl:param name="Vierde"/>
		<xsl:param name="temp1" select="translate($Eerste,',','.')"/>
		<xsl:param name="temp2" select="translate($Tweede,',','.')"/>
		<xsl:param name="temp3" select="translate($Derde,',','.')"/>
		<xsl:param name="temp4" select="translate($Vierde,',','.')"/>
		<xsl:if test="string-length($Eerste)&gt;0">
			<xsl:if test="$Eerste!=' '">
				<xsl:if test="$Eerste!='&#x0A;'">
					<xsl:if test="string-length($Tweede)&gt;0">
						<xsl:if test="$Tweede!=' '">
							<xsl:if test="$Tweede!='&#x0A;'">
								<xsl:if test="number($temp1)&gt;number($temp2)">
									<xsl:text>
										*) Deze partner heeft (op dit moment) een hoger vrij te laten bedrag dan het inkomen.
										LET OP: het is niet zo dat de vrij te laten bedragen van de partners bij elkaar opgeteld mogen worden;
										van elk afzonderlijk moet worden bepaald of hij/zij aan de boedel moet afdragen en zo ja hoeveel.
									</xsl:text>
								</xsl:if>
								<xsl:if test="number($temp1)&lt;number($temp2)">
									<xsl:if test="string-length($Derde)&gt;0">
										<xsl:if test="$Derde!=' '">
											<xsl:if test="$Derde!='&#x0A;'">
												<xsl:if test="string-length($Vierde)&gt;0">
													<xsl:if test="$Vierde!=' '">
														<xsl:if test="$Vierde!='&#x0A;'">
															<xsl:if test="number($temp3)&gt;number($temp4)">
																<xsl:text>
																	*) Deze partner heeft (op dit moment) een hoger vrij te laten bedrag dan het inkomen.
																	LET OP: het is niet zo dat de vrij te laten bedragen van de partners bij elkaar opgeteld mogen worden;
																	van elk afzonderlijk moet worden bepaald of hij/zij aan de boedel moet afdragen en zo ja hoeveel.
																</xsl:text>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
								<xsl:if test="number($temp1)=number($temp2)">
									<xsl:if test="string-length($Derde)&gt;0">
										<xsl:if test="$Derde!=' '">
											<xsl:if test="$Derde!='&#x0A;'">
												<xsl:if test="string-length($Vierde)&gt;0">
													<xsl:if test="$Vierde!=' '">
														<xsl:if test="$Vierde!='&#x0A;'">
															<xsl:if test="number($temp3)&gt;number($temp4)">
																<xsl:text>
																	*) Deze partner heeft (op dit moment) een hoger vrij te laten bedrag dan het inkomen.
																	LET OP: het is niet zo dat de vrij te laten bedragen van de partners bij elkaar opgeteld mogen worden;
																	van elk afzonderlijk moet worden bepaald of hij/zij aan de boedel moet afdragen en zo ja hoeveel.
																</xsl:text>
															</xsl:if>
														</xsl:if>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
